function [Corr] = MeEduCorr(q, Nf, Psim, Psif)

qSS_m=q(1);
qSS_f=q(2);
qUS_m=q(3);
qUS_f=q(4);
qSU_m=q(5);
qSU_f=q(6);
qUU_m=q(7);
qUU_f=q(8);


thetaSm=(1-Nf)*Psim+Nf*Psim*Psif*max(qSS_m,qSS_f)+Nf*Psim*(1-Psif)*max(qSU_m,qSU_f);
thetaUm=(1-Nf)*(1-Psim)+Nf*(1-Psim)*Psif*max(qUS_m,qUS_f)+Nf*(1-Psim)*(1-Psif)*max(qUU_m,qUU_f);
thetaSf=Nf*Psim*Psif*max(qSS_m,qSS_f)+Nf*(1-Psim)*Psif*max(qUS_m,qUS_f);
thetaUf=Nf*Psim*(1-Psif)*max(qSU_m,qSU_f)+Nf*(1-Psim)*(1-Psif)*max(qUU_m,qUU_f);

pi_SS=Nf*Psim*Psif*(1-max(qSS_m,qSS_f))+min(thetaSm,thetaSf);
pi_SU=Nf*Psim*(1-Psif)*(1-max(qSU_m,qSU_f));
pi_US=Nf*(1-Psim)*Psif*(1-max(qUS_m,qUS_f));
pi_UU=Nf*(1-Psim)*(1-Psif)*(1-max(qUU_m,qUU_f))+min(thetaUm,thetaUf);

CovXY=pi_SS/Nf-(pi_SS+pi_SU)/Nf*(pi_SS+pi_US)/Nf;
VarX=((pi_SS+pi_SU)/Nf)-((pi_SS+pi_SU)/Nf)^2;
VarY=((pi_SS+pi_US)/Nf)-((pi_SS+pi_US)/Nf)^2;

Corr=CovXY/sqrt(VarX*VarY);


end

